<?php

/**
 * This is the model class for table "UzytkownikObecnosc".
 *
 * The followings are the available columns in table 'UzytkownikObecnosc':
 * @property double $id
 * @property double $idUzytkownika
 * @property double $idTury
 * @property double $obecny
 */
class UzytkownikObecnosc extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UzytkownikObecnosc the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'UzytkownikObecnosc';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idUzytkownika, idTury', 'required'),
			array('idUzytkownika, idTury, obecny', 'numerical'),

			array('id, idUzytkownika, idTury, obecny', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'tura'=>array(self::BELONGS_TO, 'Tura', 'idTury'),
			'uczen'=>array(self::BELONGS_TO, 'Uzytkownik', 'idUzytkownika'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('UzytkownikObecnosc', 'id'),
			'idUzytkownika'=>Yii::t('UzytkownikObecnosc', 'idUzytkownika'),
			'idTury'=>Yii::t('UzytkownikObecnosc', 'idTury'),
			'obecny'=>Yii::t('UzytkownikObecnosc', 'obecny'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('idUzytkownika', $this->idUzytkownika);
		$criteria->compare('idTury', $this->idTury);
		$criteria->compare('obecny', $this->obecny);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public static function markPresenceForUsersGroup($userId)
	{
		$turaAktywna = Yii::app()->user->tura_aktywna;
		$turaKlasy = Tura::getTuraForClass(Yii::app()->user->id_klasy);
		$wlasciwaFirma = Uzytkownik::isCompanyOwner($userId, Yii::app()->user->id_firmy);

		if($turaAktywna && !empty($turaKlasy) && $wlasciwaFirma)
		{
			$uzytkownicyFirmy = Uzytkownik::model()->findAll('"idFirmy" = :idFirmy', array(':idFirmy'=>Yii::app()->user->id_firmy));

			foreach($uzytkownicyFirmy as $uzytkownik)
			{
				$log = UzytkownikObecnosc::model()->findByAttributes(array(
					'idUzytkownika'=>$uzytkownik->id,
					'idTury'=>$turaKlasy->id
				));

				if(empty($log))
				{
					$log = new UzytkownikObecnosc;
					$log->idTury = $turaKlasy->id;
					$log->idUzytkownika = $uzytkownik->id;
					$log->obecny = 1;
					$log->save(false);
				}
			}
		}
	}
}